/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.oldVersion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.pokesplash.gts.Listing.ItemListing;
import org.pokesplash.gts.Listing.PokemonListing;

public class ListingsProviderOld {
    private ArrayList<PokemonListing> pokemonListings = new ArrayList();
    private ArrayList<ItemListing> itemListings = new ArrayList();
    private HashMap<UUID, ArrayList<PokemonListing>> expiredPokemonListings = new HashMap();
    private HashMap<UUID, ArrayList<ItemListing>> expiredItemListings = new HashMap();

    public List<PokemonListing> getPokemonListings() {
        return this.pokemonListings;
    }

    public List<PokemonListing> getPokemonListingsByPlayer(UUID uuid) {
        ArrayList<PokemonListing> playerListings = new ArrayList<PokemonListing>();
        for (PokemonListing pokemonListing : this.pokemonListings) {
            if (!pokemonListing.getSellerUuid().equals(uuid)) continue;
            playerListings.add(pokemonListing);
        }
        return playerListings;
    }

    public List<ItemListing> getItemListings() {
        return this.itemListings;
    }

    private boolean hasPokemonListing(UUID listing, List<PokemonListing> pokemonListings) {
        for (PokemonListing pkm : pokemonListings) {
            if (!pkm.getId().equals(listing)) continue;
            return true;
        }
        return false;
    }

    private boolean hasItemListing(UUID listing, List<ItemListing> itemListings) {
        for (ItemListing item : itemListings) {
            if (!item.getId().equals(listing)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExpiredPokemonListings(UUID playerUUID) {
        return this.expiredPokemonListings.containsKey(playerUUID);
    }

    public boolean hasExpiredItemListings(UUID playerUUID) {
        return this.expiredItemListings.containsKey(playerUUID);
    }

    public List<PokemonListing> getExpiredPokemonListings(UUID playerId) {
        return this.expiredPokemonListings.get(playerId);
    }

    public HashMap<UUID, ArrayList<PokemonListing>> getAllExpiredPokemonListings() {
        return this.expiredPokemonListings;
    }

    public HashMap<UUID, ArrayList<ItemListing>> getAllExpiredItemListings() {
        return this.expiredItemListings;
    }

    public List<ItemListing> getExpiredItemListings(UUID playerId) {
        return this.expiredItemListings.get(playerId);
    }
}

